#version 330
#extension GL_EXT_gpu_shader4 : enable
//p6mm inversion with star patternMod01.fsh by curena
//https://www.shadertoy.com/view/Mlj3zc
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// "p6mm inversion" by Carlos Ureña - 2015
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.


// *******************************************************************
// global defs and params
//

// uncomment to perform animated circle inversion
#define INVERSION

// uncomment to view the fundamental region
//#define HILIGHT_FUNDAMENTAL        

// uncomment to view stripe animation
// #define ANIMATION

// ----------------------------------------------------------------
// parameters and pre-calculated constants

const int 
    n          = 5 ; // square root of the number of samples per pixel (for A.A.)
                     // full supersample anti-aliasing is done

const float 
    sqr2       = 1.41421356237, // square root of 2
    sqr3       = 1.73205080756, // square root of 3.0
    sqr2_inv   = 1.0/sqr2 ,
    sqr3_inv   = 1.0/sqr3 ,
    cos30      = 0.86602540378, // cos(30 degrees)
    sin30      = 0.50000000000, // sin(30 degrees)
    
    
#ifdef INVERSION
    l           = 0.1,          // length of triangle in NDC (mind --> 1.0)
#else
#ifdef HILIGHT_FUNDAMENTAL            
    l           = 5.2,
#else    
    l           = 5.5,          // length of triangle in NDC (mind --> 1.0)
#endif    
#endif
    l_inv       = 1.0/l ,       // length inverse
    line_w      = 0.03,         // line width for basic symmetry lines render
    speedFactor = 1.0 ,         // speed factor for inversion animation (greater->faster)
    sw          = 0.020 ;       // stripes half width for islamic star pattern

const vec2  
    u        = 1.0*vec2( 1.0, 0.0  ) ,          // grid basis: U vector
    v        = 0.5*vec2( 1.0, sqr3 ) ,          // grid basis: V vector
    u_dual   = 1.0*vec2( 1.0, -sqr3_inv ) ,     // dual grid basis: U vector
    v_dual   = 2.0*vec2( 0.0,  sqr3_inv ) ,     // dual grid basis: V vector
    tri_cen  = vec2( 0.5, 0.5*sqr3_inv ) ;      // triangle center
vec2
    center ; //= 0.5*iResolution.xy ;             // viewport center in DC 
float 
    mind ,   // = min(iResolution.x,iResolution.y),// minimun viewport dimension in pixels 
    secs ;   // == iTime*speedFactor ;  // global time, scaled by speed factor
    
// -----------------------------------------------------------------------------------
// point orbit transformation parameters
int 
    nMirrorOdd = 0 , 
    nMirror    = 0 ,
	nGridX     = 0 , 
    nGridY     = 0 ;


// *******************************************************************************
// functions


float NormCos( float w )
{
 	return 0.5*(1.0+cos(secs*w)) ;   
}


// -------------------------------------------------------------------------------
// mirror reflection of 'p' around and axis through 'v1' and 'v2'
// (only for points to right of the line from v1 to v2)
//
vec2 Mirror( vec2 p, vec2 v1, vec2 v2 )
{
 	vec2   s = v2-v1 ,
           n = normalize(vec2( s.y, -s.x )) ;
    float  d = dot(p-v1,n) ;
    
    if ( 0.0 <= d )
    {
       nMirrorOdd = 1-nMirrorOdd ;
       nMirror = nMirror+1 ;
       return p-2.0*d*n ;
    }
    else
       return p ;
}
// -------------------------------------------------------------------
// Signed perpendicular distance from 'p' to line through 'v1' and 'v2'

float SignedDistance( vec2 p, vec2 v1, vec2 v2 )
{
 	vec2   s = v2-v1 ,
           n = normalize(vec2( s.y, -s.x )) ;
    return dot(p-v1,n) ;
}
// -------------------------------------------------------------------
// un-normalized signed distance to line

float UnSignedDistance( vec2 p, vec2 v1, vec2 v2 )
{
 	vec2   s = v2-v1 ,
           un = vec2( s.y, -s.x ) ;
    return dot(p-v1,un) ;
}
// -------------------------------------------------------------------
// Signed perpendicular distance from 'p' to polyline from 'v1' 
// to 'v2' then to 'v3'

float DoubleSignedDistance( vec2 p, vec2 v1, vec2 v2, vec2 v3 )
{
 	
    vec2  dir1 = v2 + normalize(v1-v2),
          dir3 = v2 + normalize(v3-v2);
        
    vec2  vm = 0.5*(dir1+dir3) ;
    
    float dm = UnSignedDistance( p, v2, vm ) ;
    
    if ( dm >= 0.0 )
   		return SignedDistance( p, v1, v2 ) ;
   	else
        return SignedDistance( p, v2, v3 ) ; 
}
// -------------------------------------------------------------------------------
// Takes 'p0' to the group's fundamental region, returns its coordinates in that region

vec2 p6mm_ToFundamental( vec2 p0 ) 
{
    nMirrorOdd = 0 ;
    nMirror    = 0 ;
    
    // p1 = fragment coords. in the grid reference frame
    
    vec2 p1 = vec2( dot(p0,u_dual), dot(p0,v_dual) );
    
    // p2 = fragment coords in the translated grid reference frame 
    
    vec2 p2 = vec2( fract(p1.x), fract(p1.y) ) ;
    
    nGridX = int(p1.x-p2.x) ; // largest integer g.e. to p1.x
    nGridY = int(p1.y-p2.y) ; // largest integer g.e. to p2.x
    
    // p3 = barycentric coords in the translated triangle
    // (mirror, using line x+y-1=0 as axis, when point is right and above axis)
    
    vec2 p3 = Mirror( p2, vec2(1.0,0.0), vec2(0.0,1.0) );
    
    // p4 = p3, but expressed back in cartesian coordinates
    
    vec2 p4 = p3.x*u + p3.y*v ;
    
    // p7 = mirror around the three lines through the barycenter, perp. to edges.
    
    vec2 p5 = Mirror( p4, vec2(0.5,0.0), tri_cen );
    vec2 p6 = Mirror( p5, vec2(1.0,0.0), tri_cen );
    vec2 p7 = Mirror( p6, tri_cen, vec2(0.0,0.0) );
  
    return p7 ;
}

// --------------------------------------------------------------------
// A possible distance function

float DistanceFunc( float d )
{
   return 1.0-smoothstep( line_w*0.85, line_w*1.15, d );   
}

// -------------------------------------------------------------------------------
// Point color for basic symmetry lines in (r,g,b)

vec4 p6mm_SimmetryLines( vec2 p_ndc )
{

    vec2 pf = p6mm_ToFundamental( p_ndc );
    
    float d1 = abs(pf.y),
          d2 = abs(pf.x-0.5),
          d3 = abs( SignedDistance( pf, tri_cen, vec2(0.0,0.0) ) );
     
    vec4 res = vec4( 0.0, 0.0, 0.0, 1.0 ) ;
        
    res.r = DistanceFunc(d2);
    res.g = DistanceFunc(d1);
    res.b = DistanceFunc(d3);
    
    return res ;    
}

// ---------------------------------------------------------------------
// Stripe half width for star pattern

vec4 Stripe( float d )
{
   if ( d > sw*0.85 )
     return vec4( 0.0,0.0,0.0,1.0 );
   else
     return vec4(1.0,1.0,1.0,1.0)  ;
    
    
}

 


// ----------------------------------------------------------------------
// Converts from device (pixel) coordinates to normalized coordinates

vec2 DCToNDC( vec2 p_dc )
{
    // compute NDC:
    vec2 p = l_inv*(p_dc - center)/mind ;

#ifdef HILIGHT_FUNDAMENTAL    
    p = p + vec2(0.25*l, 0.25*l*sqr3_inv) ;
#endif
    
    // rotate 30 deg. and return
    vec2 res= vec2( p.x*cos30 - p.y*sin30,
                 p.y*cos30 + p.x*sin30 );
                    
    // flip (just to match photo)
    return vec2( res.y, res.x ) ;
}
// --------------------------------------------------------------------
// When activated, performs the circle inversion

vec2 Inversion( vec2 p, vec2 cen )
{
#ifdef INVERSION     
   vec2  vr   = p  -cen ;
   float r    = length( vr );
   
    return cen + normalize(vr)/(r*0.1) 
              + secs/4.0*vec2(1.0,0.5)  
              + 1.0*l*vec2( sin(secs/40.0), cos(secs/42.0) ) ;
#else
   return p*13.0 ;  // an arbitrary constant to allow seeing a bigger region
#endif
}

// ---------------------------------------------------------------------
// Color for islamic star pattern

vec4 p6mm_Stripes( vec2 p_ndc )
{
    vec2 pf = p6mm_ToFundamental( p_ndc );
    vec2 c  = tri_cen ;
    
    // constants defining the stripes 
    float 
        f   = 0.30 ,
        fs1 = 0.14 ,
        s1  = fs1*c.x,
        s2  = 0.5*s1 ;
        
    // stripes vertexes
    vec2 
        // upper strip
        u1 = vec2( f*c.x, 0.0 ) ,
        u2 = vec2( c.x, (1.0-f)*c.y ),
        
        // lower strip
        l1 = vec2( c.x, s1+s2 ),
        l2 = vec2( c.x-s2, s1 ),
        l3 = vec2( sqr3*s1, s1 ),
        
        // right strip
        r1 = vec2( c.x-s1, (1.0-fs1)*c.y ),
        r2 = vec2( c.x-s1, s2 ) ,
        r3 = vec2( c.x-s1-s2, 0.0 ),
        
    	// origin star strip
        mm = vec2( s1*(sqr3-1.0/3.0), s1*(1.0-sqr3_inv) );
    
#ifdef ANIMATION    
    const float k = 0.3 ;
    
    vec2 u2_despl = vec2(c.x,NormCos(1.0*k)*c.y), 
         u1_despl = vec2(NormCos(2.0*k)*c.x, 0.0),
         l1_despl = vec2(c.x,s1+NormCos(3.0*k)*(c.y-s1)), 
         r3_despl = vec2((1.0-s1)*NormCos(5.0*k)*c.x, 0.0);
    
    u1 = 0.5*(u1+u1_despl) ;
    u2 = 0.5*(u2+u2_despl) ;
    l1 = 0.5*(l1+l1_despl) ;
    r3 = 0.5*(r3+r3_despl);
#endif    
                    
    // signed and unsigned distances to stripes:
    
    float
        d1s = SignedDistance( pf, u1, u2 ) ,
        d2s = DoubleSignedDistance( pf, l1, l2, l3 ) ,
        d3s = DoubleSignedDistance( pf, r1, r2, r3 ) ,
        d4s = DoubleSignedDistance( pf, u1, mm, l3 ) ,
        d1  = abs( d1s ),
        d2  = abs( d2s ),
        d3  = abs( d3s ),
        d4  = abs( d4s );
    
   
    // stripes inclusion
    bool in1, in2, in3, in4 ;
    
    if ( nMirrorOdd == 0 )
    {
        in1 = (d1 < sw) && ! (d2 < sw) && ! (d4 < sw);
        in2 = (d2 < sw) && ! (d3 < sw);
        in3 = (d3 < sw) && ! (d1 < sw);
        
        in4 = (d4 < sw) && ! (d2 < sw);
    }
    else
    {
        in1 = (d1 < sw) && ! (d3 < sw) ;
        in2 = (d2 < sw) && ! (d1 < sw) && ! (d4 < sw);;
        in3 = (d3 < sw) && ! (d2 < sw);
        
        in4 = (d4 < sw) && ! (d1 < sw);
    } 
    
    vec4 col ;
    
    // compute final color
    
    if ( in1 )      
        col = Stripe( d1 ) ;
    else if ( in2 ) 
        col = Stripe( d2 ) ;
    else if ( in3 ) 
        col = Stripe( d3 ) ; 
    else if ( in4 )
        col = Stripe( d4 ) ;   
    else if ( d2s < 0.0 && d3s < 0.0 )
        col = vec4( 0.0, 0.4, 0.0, 1.0 ) ;
    else if ( d1s < 0.0 && d2s < 0.0 || d1s <0.0 && d3s < 0.0 )
        col = vec4( 0.1, 0.1, 0.1, 1.0 );
    else if ( d1s < 0.0 || d2s < 0.0 )
        col = vec4( 0.0, 0.4, 0.9, 1.0 );   
    else    
        col = vec4( 0.6, 0.0, 0.0, 1.0 ) ; 
        
#ifdef HILIGHT_FUNDAMENTAL        
    if ( nMirror != 0 || nGridX != 0 || nGridY != 0 )
     	col = 0.9*vec4(0.5,0.5,0.5,1) + 0.1*col ;   
#endif
        
    return col ;
}
                  
// ------------------------------------------------------------
// islamic star pattern, for a point in DC coordinates

vec2 mou ; //= DCToNDC( 0.5*iResolution.xy ); // mouse pressed position (==center before pressing)
                  
vec4 p6mm_Stripes_dc( vec2 p_dc )                 
{
  vec2 p_ndc = Inversion( DCToNDC( p_dc ), mou );
  return p6mm_Stripes( p_ndc ) ;          
}

// --------------------------------------------------------------------
// camera in world coordinates
// (in world coordinates, Z is the vertical direction)

float near = 1.7 ;

vec3 eye_pos = vec3( -1.0, -1.5, 1.0 ),
     look_at = vec3( 0.0, 0.0, 0.0 ),
     eye_vup = vec3( 0.0, 0.0, 1.0 );

vec3 eye_z    , //= normalize( eye_pos-look_at ) ,
     eye_x   , //= normalize( cross( eye_vup, eye_z ) ),
     eye_y   ; //= normalize( cross( eye_z, eye_x ) ); 

// -------------------------------------------------------------------------------

vec3 GetDir( vec2 p_dc )
{
    vec2        p_ndc = 2.0*(p_dc-center)/mind ;      
    vec3        dir   = normalize( p_ndc.x*eye_x 
                                   + p_ndc.y*eye_y 
                                   - near*eye_z );
    const float wd    = 0.3 ;
    float       c     = cos( iTime*wd ), 
                s     = sin( iTime*wd ) ;
     
    return vec3(  dir.x*c - dir.y*s,
                  dir.y*c + dir.x*s,
                  dir.z);
}

// -------------------------------------------------------------------------------

vec4 Sky( vec3 ndir ) // ndir == normalized direction
{
   float z = max( ndir.z, 0.0 ) ;   
   return vec4( 0.5,0.5,0.5, 1.0) + z*0.5*vec4( 0.3, 0.4, 0.5, 1.0 ) ;
    
}

float Luminance( vec4 col )
{
   return col.r ; //0.3333*( col.r+col.g+col.b ) ;   
    
}

// -------------------------------------------------------------------------------

vec3 GetNormal( vec2 pos )
{
    const float d = 0.003 ;   
    
    vec2 dx = vec2( d, 0.0 ),
         dy = vec2( 0.0, d );
    float h0  = Luminance( p6mm_Stripes( pos )),
          hdx = Luminance( p6mm_Stripes( pos+dx )),
          hdy = Luminance( p6mm_Stripes( pos+dy ));
    vec3 vdx = vec3( d, 0.0, 2.0*(hdx-h0) ),
         vdy = vec3( 0.0, d, 2.0*(hdy-h0) );
    
    vec3 nor = normalize( cross( vdx, vdy ) );

    if ( nor.z < 0.0 ) nor = -nor ;
    return nor ;
}

// -------------------------------------------------------------------------------

struct TraceState
{
    vec3  ray_org, 
          ray_dir,
          hit_pos,
          hit_nor ;
    float hit_col,
          tmin ;
          
    
} ;
    
void BasePlane( inout TraceState ts )
{
    if ( ts.ray_dir.z > 0.0 ) // ray to the sky
       return ; 
    
    // find distance (t) to intersection with plane z=0
   float t = - ts.ray_org.z / ts.ray_dir.z ;
    
   if ( t < 0.0 ) // t must be positive
       return  ; // use red to flag an error
    
   // if t is further away than previous, exit
   if ( ts.tmin >= 0.0 )
   if ( t > ts.tmin )
       return ;
       
    // intersection point
   vec3 p_int = ts.ray_org + t*ts.ray_dir ; 
    
  
   // if out limits, return
   const float hs = 60.0 ;  
   if ( abs( p_int.x ) > hs || abs( p_int.y ) > hs )
       return ;
    
   // convert to ndc and do inversion
   vec2 p_int_ndc = Inversion( 0.5*p_int.xy, vec2(0.0,0.0) ) ;
   vec4 col = p6mm_Stripes( p_int_ndc ) ;
   
   // compute normal
   vec3 nor = GetNormal( p_int_ndc ); 
    //nor = vec3( 0.0, 0.0, 1.0 );
    
    
}

// ------------------------
vec4 RayTrace_dc( vec2 p_dc )
{
   vec3 ray_org = eye_pos,
        ray_dir = GetDir( p_dc ) ;
   
   if ( ray_dir.z > 0.0 ) // ray to the sky
       return vec4( 0.5, 0.5, 0.8, 1.0 ); 
    
    // find distance (t) to intersection with plane z=0
   float t = - ray_org.z / ray_dir.z ;
    
   if ( t < 0.0 ) // t must be positive
       return Sky( ray_dir) ; // use red to flag an error
    
   vec3 p_int = ray_org + t*ray_dir ;  // intersection point
    
  
   // if out limits, return
   const float hs = 60.0 ;  
   if ( abs( p_int.x ) > hs || abs( p_int.y ) > hs )
       return vec4( 0.0, 0.0, 1.0, 1.0 ) ;//Sky( ray_dir ) ;
    
   // convert to ndc and do inversion
   vec2 p_int_ndc = Inversion( 0.5*p_int.xy, vec2(0.0,0.0) ) ;
   vec4 col = p6mm_Stripes( p_int_ndc ) ;
   
   // compute normal
   vec3 nor = GetNormal( p_int_ndc ); 
    //nor = vec3( 0.0, 0.0, 1.0 );
   
   // dir to light
   vec3 ldir = normalize( vec3( 1.0, 0.2, 1.0 ) ) ;
    
   // vector to viewer (and reflected)
   vec3 vv = normalize( -ray_dir );
    
   if ( vv.z < 0.0 ) vv = -1.0*vv ;
   vec3 vvr = normalize(vv- 2.0*dot( vv,nor)*nor) ;
    
   // MIL
   float nl = max( 0.0, dot(nor,ldir) ),
         rv = max( 0.0, dot(ldir,vvr) ),
         pexp = 1.0 ;
    
  const float kd = 1.1, ks = 1.2 ;
    
  return kd*nl*col + ks*pow( rv, pexp)*vec4( 1.0, 1.0, 1.0, 1.0 ); 
   
}

// -------------------------------------------------------------------------------
// main color computing function for a point in device coordinates

vec4 MainColorFunction_dc( vec2 p_dc )
{
    return p6mm_Stripes_dc( p_dc );  // islamic star pattern 
    //return RayTrace_dc( p_dc ) ;
}

// -------------------------------------------------------------------------------
// initialize globals which depend on values known at run-time 

void InitGlobals()
{
    center = 0.5*iResolution.xy ;             // viewport center in DC 
    mind   = min(iResolution.x,iResolution.y); // minimun viewport dimension in pixels 
    secs   = iTime*speedFactor ;  // global time, scaled by speed factor
    mou    = DCToNDC( 0.5*iResolution.xy ); // mouse pressed position (==center before pressing)
    
    // eye pos
    eye_z  = normalize( eye_pos-look_at ) ;
    eye_x  = normalize( cross( eye_vup, eye_z ) );
    eye_y  = normalize( cross( eye_z, eye_x ) ); 
}
 
// -------------------------------------------------------------------------------
// main function, does multi-sample anti-aliasing
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    
    InitGlobals() ;
    
    const float n_inv = 1.0/float(n) ;
    vec4 res          = vec4( 0.0, 0.0, 0.0, 1.0 );
    
    if ( iMouse.w != 0.0 )
        mou  = DCToNDC( iMouse.xy  ) ;
    
    for (int ix = 0 ; ix < n ; ix += 1 )
    for (int iy = 0 ; iy < n ; iy += 1 )
    {
       float px = -0.5 + (0.5+float(ix))*n_inv,   
             py = -0.5 + (0.5+float(iy))*n_inv ;
        
       vec2 p_dc = gl_FragCoord.xy + vec2( px, py ) ;
       res += MainColorFunction_dc( p_dc );
    }
    gl_FragColor = n_inv*n_inv*res ;   
}